
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;

// https://en.wikipedia.org/wiki/Factorization_of_polynomials_over_finite_fields#Square-free_factorization

int main (int argc, char * const argv[])
{
    matq        seed;
    double      p;
    int         m, k;
    bf          det;
    
again:
    p = 0;
    while(p<2 || !isItPrime(p, 35))
    {
        cout << "p: ";
        cin >> p;
    }
    //cin.ignore();  // needed for next cin with prompt to behave
    
    m = 0;
    while(m<1)
    {
        cout << "m: ";
        cin >> m;
    }
    
    k = pow(p, m) - 1; // want a^k = I
    cout << "k = " << pow(p, m)-1 << endl << endl;
    
    det = genMatrixSeed(seed, m, p);
    cout << "det = " << det << endl;
    cout << "seed = " << seed << endl << endl;
    
    goto again;
    
    return 0;
}
 /*
 clock_t start, end;
 double elapsed;
 
 start = clock();

end = clock();
elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
 */
